/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.client.render.entity;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import morph.avaritia.entity.GapingVoidEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class GapingVoidEntityRenderer
extends EntityRenderer<GapingVoidEntity> {
    private static final ResourceLocation VOID_HALO = new ResourceLocation("avaritia", "textures/entity/void_halo.png");
    private static final RenderType VOID_HALO_RENDER_TYPE = RenderType.m_173209_((String)"avaritia:void_halo", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173101_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(VOID_HALO, false, false)).m_110685_(RenderType.f_110139_).m_110687_(RenderType.f_110115_).m_110691_(false));
    private static final ResourceLocation VOID = new ResourceLocation("avaritia", "textures/entity/void.png");
    private static final ResourceLocation HEMISPHERE_MODEL = new ResourceLocation("avaritia", "model/hemisphere.obj");
    private static final RenderType VOID_HEMISPHERE_RENDER_TYPE = RenderType.m_173209_((String)"avaritia:void_hemisphere", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173098_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(VOID, false, false)).m_110661_(RenderType.f_110110_).m_110691_(false));
    private final CCModel hemisphere = (CCModel)new OBJParser(HEMISPHERE_MODEL).parse().get("model");

    public GapingVoidEntityRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public void render(GapingVoidEntity entity, float entityYaw, float partialTicks, PoseStack pStack, MultiBufferSource buffers, int packedLight) {
        double age = (float)entity.getAge() + partialTicks;
        Colour colour = GapingVoidEntityRenderer.getColour(age, 1.0);
        double scale = GapingVoidEntity.getVoidScale(age);
        double fullfadedist = 0.6 * scale;
        double fadedist = fullfadedist + 1.5;
        double halocoord = 0.58 * scale;
        double haloscaledist = 2.2 * scale;
        Vec3 camera = this.f_114476_.f_114358_.m_90583_();
        double dx = entity.m_20185_() - camera.m_7096_();
        double dy = entity.m_20186_() - camera.m_7098_();
        double dz = entity.m_20189_() - camera.m_7094_();
        double xzlen = Math.sqrt(dx * dx + dz * dz);
        double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (len <= haloscaledist) {
            double close = (haloscaledist - len) / haloscaledist;
            halocoord *= 1.0 + close * close * close * close * 1.5;
        }
        double yang = Math.atan2(xzlen, dy) * 57.29577951308232;
        double xang = Math.atan2(dx, dz) * 57.29577951308232;
        pStack.m_85836_();
        pStack.m_85845_(new Quaternion(Vector3f.f_122225_, (float)xang, true));
        pStack.m_85845_(new Quaternion(Vector3f.f_122223_, (float)(yang + 90.0), true));
        pStack.m_85836_();
        pStack.m_85845_(new Quaternion(Vector3f.f_122223_, 90.0f, true));
        TransformingVertexConsumer cons = new TransformingVertexConsumer(buffers.m_6299_(VOID_HALO_RENDER_TYPE), pStack);
        cons.m_5483_(-halocoord, 0.0, -halocoord).m_6122_((int)colour.r, (int)colour.g, (int)colour.b, (int)colour.a).m_7421_(0.0f, 0.0f).m_5752_();
        cons.m_5483_(-halocoord, 0.0, halocoord).m_6122_((int)colour.r, (int)colour.g, (int)colour.b, (int)colour.a).m_7421_(0.0f, 1.0f).m_5752_();
        cons.m_5483_(halocoord, 0.0, halocoord).m_6122_((int)colour.r, (int)colour.g, (int)colour.b, (int)colour.a).m_7421_(1.0f, 1.0f).m_5752_();
        cons.m_5483_(halocoord, 0.0, -halocoord).m_6122_((int)colour.r, (int)colour.g, (int)colour.b, (int)colour.a).m_7421_(1.0f, 0.0f).m_5752_();
        pStack.m_85849_();
        pStack.m_85841_((float)scale, (float)scale, (float)scale);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind(VOID_HEMISPHERE_RENDER_TYPE, buffers, pStack);
        ccrs.baseColour = colour.rgba();
        this.hemisphere.render(ccrs, new IVertexOperation[0]);
        pStack.m_85849_();
    }

    private static Colour getColour(double age, double alpha) {
        double life = age / 186.0;
        double f = Math.max(0.0, (life - 0.95) / 0.050000000000000044);
        f = Math.max(f, 1.0 - life * 30.0);
        return new ColourRGBA(f, f, f, alpha);
    }

    public ResourceLocation getTextureLocation(GapingVoidEntity p_114482_) {
        return VOID;
    }
}

